<?php
session_start();

// Generate a random code and store it in the session
$randomCode = rand(1000, 9999);
$_SESSION['captcha_code'] = $randomCode;

// Create an image with the code
$image = imagecreate(100, 40);
$background_color = imagecolorallocate($image, 255, 255, 255); // White background
$text_color = imagecolorallocate($image, 0, 0, 0); // Black text
imagestring($image, 5, 20, 12, $randomCode, $text_color);

// Set the content type header for PNG image
header('Content-Type: image/png');

// Output the image
imagepng($image);

// Free up memory
imagedestroy($image);
?>
