<?php
require_once('session.php');

// Check if the request is over HTTPS
if (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] !== 'on') {
    header("HTTP/1.1 403 Forbidden");
    echo "Access forbidden. Use HTTPS.";
    exit();
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    if (isset($_POST['csrf_token']) && hash_equals($_POST['csrf_token'], $_SESSION['csrf_token'])) {
        if ($_POST['captcha_input'] != $_SESSION['captcha_code']) {
            echo "Captcha salah.";
            exit;
        }

        $password = mysqli_real_escape_string($conn, $_POST['password']); // Sanitize password input
        $currentPass = $u['pass']; // Make sure $u['pass'] contains the hashed password

        if (password_verify($password, $currentPass)) {
            if ($u['cuid'] == 1) {
                $users = $u['user'];

                $target_file = null; // Default value if no file is uploaded

                if (!empty($_FILES['image']['name'])) {
                    // Handle file upload if a file is provided
                    $target_dir = "../../upload/"; // Directory where the file will be uploaded
                    $target_file = $target_dir . basename($_FILES["image"]["name"]);
                    $targetfile = basename($_FILES["image"]["name"]);
                    $uploadOk = 1;
                    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

                    // Check if image file is a actual image or fake image
                    $check = getimagesize($_FILES["image"]["tmp_name"]);
                    if ($check !== false) {
                        $uploadOk = 1;
                    } else {
                        echo "File is not an image.";
                        $uploadOk = 0;
                    }

                    // Check file size (5MB maximum)
                    if ($_FILES["image"]["size"] > 50000000) {
                        echo "Sorry, your file is too large.";
                        $uploadOk = 0;
                    }

                    // Allow certain file formats
                    if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif") {
                        echo "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
                        $uploadOk = 0;
                    }

                    // Check if $uploadOk is set to 0 by an error
                    if ($uploadOk == 0) {
                        echo "Sorry, your file was not uploaded.";
                        $target_file = null; // Reset target_file if upload fails
                    } else {
                        if (!move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
                            echo "Sorry, there was an error uploading your file.";
                            $target_file = null; // Reset target_file if move fails
                        }
                    }
                }

                // Continue processing and inserting data even if no file was uploaded
                $akun = filter_input(INPUT_POST, 'akun', FILTER_SANITIZE_STRING);
                $no_rek = filter_input(INPUT_POST, 'no_rek', FILTER_SANITIZE_NUMBER_INT);
                $no_rek = preg_replace("/[^0-9]/", "", $no_rek);

                // Validate $no_rek here if needed

                $pemilik = filter_input(INPUT_POST, 'pemilik', FILTER_SANITIZE_STRING);
                $created_date = date('Y-m-d H:i:s');

                // Insert data into the database
                $query = mysqli_query($conn, "INSERT INTO `tb_bank` (`image`, `akun`, `no_rek`, `pemilik`, `status`,`userID`) VALUES ('$targetfile', '$akun','$no_rek','$pemilik',1,1)") or die(mysqli_error($conn));

                header('location:../bank/');
            } else {
                echo 'BOKEP CXFTEAMS';
            }
        } else {
            echo 'PASSWORD SALAH';
        }
    } else {
        // Regenerate CSRF token on each form request
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));

        // CSRF token is invalid, handle the error
        echo "Ngapain Bang Ngetamper Data Kah?";
        exit();
    }
}
?>

